#!/bin/bash
# Navigate to your Ruffle directory
cd /var/www/examplesite.tld/public_html/ruffle/ || exit

# Query GitHub API for the latest nightly release and extract the selfhosted web build URL
url=$(curl -s https://api.github.com/repos/ruffle-rs/ruffle/releases \
  | grep "browser_download_url.*web-selfhosted.zip" \
  | head -n 1 \
  | cut -d '"' -f 4)

# Safety check: bail if no URL was found
if [ -z "$url" ]; then
  echo "Failed to fetch nightly build URL."
  exit 1
fi

echo "Downloading $url"

# Download the ZIP
curl -L -o ruffle-nightly.zip "$url"

# Extract and overwrite existing files
unzip -o ruffle-nightly.zip

# Remove the zip after extraction
rm ruffle-nightly.zip

# Extract the nightly date from the URL and report it
build_date=$(echo "$url" | grep -oP 'nightly-\K[0-9]{4}-[0-9]{2}-[0-9]{2}')
echo "Installed Ruffle nightly build from $build_date"