#!/bin/ash

awk '
BEGIN {
    FS=" ";
}

# Step 1: load IPv4 leases
{
    mac=toupper($2);
    ipv4=$3;
    host=$4;

    devices[mac] = devices[mac] "\"ipv4\":\"" ipv4 "\",\"hostname\":\"" host "\",";
}

END {
    # Step 2: merge IPv6 neighbors
    while (( "ip -6 neigh" | getline line ) > 0 ) {
        split(line, a, " ");
        ip6=a[1];
        mac=toupper(a[5]);

        if (mac != "") {
            ipv6list[mac] = ipv6list[mac] ip6 "\n";
        }
    }
    close("ip -6 neigh");

    # Step 3: merge IPv4 neighbors
    while (( "ip neigh" | getline line ) > 0 ) {
        split(line, a, " ");
        ip4=a[1];
        mac=toupper(a[5]);

        if (mac != "") {
            neigh4[mac] = neigh4[mac] ip4 "\n";
        }
    }
    close("ip neigh");

    # Step 4: output JSON
    print "{";
    first=1;

    for (mac in devices) {
        if (!first) print ",";
        first=0;

        printf "\"%s\":{", mac;

        # base info
        printf "%s", devices[mac];

        ###############################
        # IPv6 ARRAY (fixed)
        ###############################
        if (ipv6list[mac] != "") {
            printf "\"ipv6\":[";
            n = split(ipv6list[mac], arr, "\n");
            count = 0;
            for (i = 1; i <= n; i++) {
                if (arr[i] != "") {
                    if (count > 0) printf ",";
                    printf "\"%s\"", arr[i];
                    count++;
                }
            }
            printf "],";
        }

        ###############################
        # IPv4 NEIGH ARRAY (fixed)
        ###############################
        if (neigh4[mac] != "") {
            printf "\"ipv4_neigh\":[";
            n = split(neigh4[mac], arr, "\n");
            count = 0;
            for (i = 1; i <= n; i++) {
                if (arr[i] != "") {
                    if (count > 0) printf ",";
                    printf "\"%s\"", arr[i];
                    count++;
                }
            }
            printf "],";
        }

        # final field
        printf "\"mac\":\"%s\"", mac;

        printf "}";
    }

    print "}";
}
' /tmp/dhcp.leases
