#!/bin/bash

CONFIG="/home/user/scripts/dynamicdns.conf"
CURRENT_IPV4=$(curl -s https://api.ipify.org)
CURRENT_IPV6=$(curl -s https://api6.ipify.org)

echo "Sanity check at $(date)"
echo "IPv4: $CURRENT_IPV4"
echo "IPv6: $CURRENT_IPV6"
echo

while read -r DOMAIN PASSWORD; do
    [[ "$DOMAIN" =~ ^#.*$ || "$PASSWORD" == "reserved" ]] && continue

    echo "Testing $DOMAIN..."
    RESP4=$(curl -s "https://dyn.dns.he.net/nic/update?hostname=$DOMAIN&password=$PASSWORD&myip=$CURRENT_IPV4")
    echo "  IPv4 → $RESP4"

    RESP6=$(curl -s "https://dyn.dns.he.net/nic/update?hostname=$DOMAIN&password=$PASSWORD&myip=$CURRENT_IPV6")
    echo "  IPv6 → $RESP6"
    echo
done < "$CONFIG"